<?php
/**
 * The template for displaying the header
 *
 * Displays all of the head element and everything up until the "site-content" div.
 *
 * @package WordPress
 * @subpackage Superio
 * @since Superio 1.0
 */
?><!DOCTYPE html>
<html <?php language_attributes(); ?> class="no-js">
<head>
	<script type="application/ld+json">
{
  "@context": "https://schema.org",
  "@type": "Corporation",
  "name": "Alovieclamonline.com - Website đăng tin tuyển dụng việc làm thu nhập cao 2024",
  "alternateName": "Alovieclamonline",
  "url": "https://alovieclamonline.com",
  "logo": "https://alovieclamonline.com/wp-content/uploads/2024/01/logo-alovieclamonline.png",
  "contactPoint": {
    "@type": "ContactPoint",
    "telephone": "0852 716 253",
    "contactType": "technical support",
    "contactOption": "TollFree",
    "areaServed": "VN",
    "availableLanguage": "Vietnamese"
  },
  "sameAs": [
    "https://www.youtube.com/@Alovieclamonline",
    "https://www.pinterest.com/alovieclamonline/",
    "https://www.linkedin.com/in/alovieclamonline/",
    "https://twitter.com/alovieclamOL",
    "https://www.reddit.com/user/alovieclamonline/",
    "https://alovieclamonline24h.tumblr.com/",
    "https://sites.google.com/view/alovieclamonline",
    "https://www.blogger.com/profile/14585564970967139381"
  ]
}
</script>
<script type="application/ld+json">
{
  "@context": "https://schema.org",
  "@type": "ProfessionalService",
  "name": "Alovieclamonline.com - Website đăng tin tuyển dụng việc làm thu nhập cao 2024",
  "image": "https://alovieclamonline.com/wp-content/uploads/2024/01/logo-alovieclamonline.png",
  "@id": "https://alovieclamonline.com",
  "url": "https://alovieclamonline.com",
  "telephone": "0852 716 253",
  "address": {
    "@type": "PostalAddress",
    "streetAddress": "87 Lê Thị Hồng, Phường 7, Gò Vấp, Thành phố Hồ Chí Minh, Việt Nam",
    "addressLocality": "Thành phố Hồ Chí Minh",
    "postalCode": "70000",
    "addressCountry": "VN"
  },
  "geo": {
    "@type": "GeoCoordinates",
    "latitude": 10.8327718,
    "longitude": 106.6788898
  },
  "openingHoursSpecification": {
    "@type": "OpeningHoursSpecification",
    "dayOfWeek": [
      "Monday",
      "Tuesday",
      "Wednesday",
      "Thursday",
      "Friday",
      "Saturday",
      "Sunday"
    ],
    "opens": "00:00",
    "closes": "23:59"
  },
  "sameAs": [
    "https://www.youtube.com/@Alovieclamonline",
    "https://www.pinterest.com/alovieclamonline/",
    "https://www.linkedin.com/in/alovieclamonline/",
    "https://twitter.com/alovieclamOL",
    "https://www.reddit.com/user/alovieclamonline/",
    "https://alovieclamonline24h.tumblr.com/",
    "https://sites.google.com/view/alovieclamonline",
    "https://www.blogger.com/profile/14585564970967139381"
  ] 
}
</script>
	<script type="application/ld+json">
{
  "@context": "https://schema.org/",
  "@type": "Person",
  "name": "Phan Minh Nhật",
  "url": "https://alovieclamonline.com/author/admin/",
  "image": "https://cdn.24h.com.vn/upload/3-2020/images/2020-08-14/Hanh-trinh-khoi-nghiep-tu-hai-ban-tay-trang-cua-chang-doanh-nhan-tre-Quang-Huy-quang-huy-2-1597370887-514-width600height400.jpg",
  "sameAs": [
    "https://www.youtube.com/@ceoalovieclamonline/about",
    "https://www.pinterest.com/ceoalovieclamonline/",
    "https://www.linkedin.com/in/ceophanminhnhat/",
    "https://twitter.com/_phanminhnhat",
    "https://www.reddit.com/user/ceoalovieclamonline/",
    "https://phanminhnhat.tumblr.com/",
    "https://sites.google.com/view/ceophanminhnhat",
    "https://www.blogger.com/profile/08362487718621698469"
  ],
  "jobTitle": "CEO",
  "worksFor": {
    "@type": "Organization",
    "name": "Alovieclamonline"
  }  
}
</script>
	<meta charset="<?php bloginfo( 'charset' ); ?>">
	<meta name="google-site-verification" content="dwlvrbCzB-8n7QWbNGWe48T4sizARjoszPozH0o-w6o" />
	<meta name="viewport" content="width=device-width">
	<link rel="profile" href="//gmpg.org/xfn/11">	
	<?php wp_head(); ?>
	<!-- Google tag (gtag.js) -->
	<script async src="https://www.googletagmanager.com/gtag/js?id=G-365ZEJ7FM0"></script>
	<script>
	  window.dataLayer = window.dataLayer || [];
	  function gtag(){dataLayer.push(arguments);}
	  gtag('js', new Date());
	  gtag('config', 'G-365ZEJ7FM0');
	</script>
	<meta name='dmca-site-verification' content='OTZwMEZQZEJEWWtqaGhyREh5Q1JoN0NSb3djbUJTRGVTa29JNXQ3QjdHWT01' />
</head>
<body <?php body_class(); ?>>
<?php if ( superio_get_config('preload', true) ) {
	$preload_icon = superio_get_config('media-preload-icon');
	$styles = array();
	if ( !empty($preload_icon['id']) ) {
		$img = wp_get_attachment_image_src($preload_icon['id'], 'full');
		if ( !empty($img[0]) ) {
			$styles[] = 'background-image: url(\''.$img[0].'\');';
		}
		if ( !empty($img[1]) ) {
			$styles[] = 'width: '.$img[1].'px;';
		}
		if ( !empty($img[1]) ) {
			$styles[] = 'height: '.$img[2].'px;';
		}
    }
    $style_attr = '';
    if ( !empty($styles) ) {
    	$style_attr = 'style="'.implode(' ', $styles).'"';
    }
?>
	<div class="apus-page-loading">
        <div class="apus-loader-inner" <?php echo trim($style_attr); ?>></div>
    </div>
<?php } ?>
<div id="wrapper-container" class="wrapper-container">
	<?php
    if ( function_exists( 'wp_body_open' ) ) {
        wp_body_open();
    }
    if ( superio_get_config('separate_header_mobile', true) ) {
	    get_template_part( 'headers/mobile/offcanvas-menu' );
		get_template_part( 'headers/mobile/header-mobile' );
	}
	?>

	<?php
		$header = apply_filters( 'superio_get_header_layout', superio_get_config('header_type') );
		if ( !empty($header) ) {
			superio_display_header_builder($header);
		} else {
			get_template_part( 'headers/default' );
		}
	?>
	<div id="apus-main-content">